/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.event;

import com.lothrazar.cyclic.block.antipotion.BlockAntiBeacon;
import com.lothrazar.cyclic.potion.CyclicMobEffect;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.PotionEffectRegistry;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PotionEvents {
    @SubscribeEvent
    public void onPotionAdded(PotionEvent.PotionAddedEvent event) {
        MobEffect mobEffect = event.getPotionEffect().m_19544_();
        if (mobEffect instanceof CyclicMobEffect) {
            CyclicMobEffect self = (CyclicMobEffect)mobEffect;
            self.onPotionAdded(event);
        }
    }

    @SubscribeEvent
    public void isPotionApplicable(PotionEvent.PotionApplicableEvent event) {
        MobEffect mobEffect = event.getPotionEffect().m_19544_();
        if (mobEffect instanceof CyclicMobEffect) {
            CyclicMobEffect self = (CyclicMobEffect)mobEffect;
            self.isPotionApplicable(event);
        }
        ((BlockAntiBeacon)((Object)BlockRegistry.ANTI_BEACON.get())).isPotionApplicable(event);
    }

    @SubscribeEvent
    public void onPotionRemove(PotionEvent.PotionRemoveEvent event) {
        MobEffect mobEffect = event.getPotion();
        if (mobEffect instanceof CyclicMobEffect) {
            CyclicMobEffect self = (CyclicMobEffect)mobEffect;
            self.onPotionRemove(event);
        }
    }

    @SubscribeEvent
    public void onPotionExpiry(PotionEvent.PotionExpiryEvent event) {
        MobEffect mobEffect = event.getPotionEffect().m_19544_();
        if (mobEffect instanceof CyclicMobEffect) {
            CyclicMobEffect self = (CyclicMobEffect)mobEffect;
            self.onPotionExpiry(event);
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity == null) {
            return;
        }
        for (CyclicMobEffect effect : PotionEffectRegistry.EFFECTS) {
            if (effect == null || !entity.m_21023_((MobEffect)effect)) continue;
            effect.tick(event);
        }
    }
}

